local assets=
{
	Asset("ANIM", "anim/nightmaresword.zip"),
	Asset("ANIM", "anim/swap_nightmaresword.zip"),
    
}

local function onfinished(inst)
    inst:Remove()
	inst.SoundEmitter:PlaySound("dontstarve/wilson/attack_nightsword")
	SpawnPrefab("statue_transition").Transform:SetPosition(inst:GetPosition():Get())
	SpawnPrefab("statue_transition_2").Transform:SetPosition(inst:GetPosition():Get())
end

local function onequip(inst, owner)
	owner:AddTag("NightmareThree")
    owner.AnimState:OverrideSymbol("swap_object", "swap_nightmaresword", "swap_nightmaresword")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
	SpawnPrefab("statue_transition_2").Transform:SetPosition(inst:GetPosition():Get())	
	inst.SoundEmitter:PlaySound("dontstarve/wilson/attack_nightsword")
end

local function onunequip(inst, owner) 
	owner:RemoveTag("NightmareThree")
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
	SpawnPrefab("statue_transition_2").Transform:SetPosition(inst:GetPosition():Get())	
	inst.SoundEmitter:PlaySound("dontstarve/wilson/attack_nightsword")
end


local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
	inst.entity:AddSoundEmitter()
    
    inst.AnimState:SetBank("nightmaresword")
    inst.AnimState:SetBuild("nightmaresword")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:SetMultColour(1, 1, 1, 0.6)
    
    inst:AddTag("shadow")
    inst:AddTag("sharp")
    
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.NIGHTSWORD_DAMAGE)
    
    -------
    
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(TUNING.NIGHTSWORD_USES)
    inst.components.finiteuses:SetUses(TUNING.NIGHTSWORD_USES)
    
    inst.components.finiteuses:SetOnFinished( onfinished )

	--[[local base_finiteuses_OnUsedAsItem = inst.components.finiteuses.OnUsedAsItem
inst.components.finiteuses.OnUsedAsItem = function( self, action )
	base_finiteuses_OnUsedAsItem( self, action )
	
    	if action == ACTIONS.ATTACK then
		if self.inst.components.inventoryitem and self.inst.components.inventoryitem.owner then
			local owner = self.inst.components.inventoryitem.owner
			--owner.components.sanity:DoDelta( -.20 )
			SpawnPrefab("statue_transition").Transform:SetPosition(inst:GetPosition():Get())
			inst.SoundEmitter:PlaySound("dontstarve/wilson/attack_nightsword")
		end
	end
end]]
	
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
	
	if IsDLCEnabled(REIGN_OF_GIANTS) then
	inst.components.equippable.dapperness = TUNING.CRAZINESS_MED
	else
	inst:AddComponent("dapperness")
	inst.components.dapperness.dapperness = TUNING.CRAZINESS_MED
	end
    
    return inst
end

return Prefab( "common/inventory/nightsword", fn, assets) 
